# Key mapping for 'emacs' editor personality.  See the file 
# keymap.basic for format and usage details.

%include keymap.basic

# Overrides and additions related to above

'Home': 'beginning-of-line'
'Shift-Home': 'beginning-of-line-extend'
'KP_Home': 'beginning-of-line'
'Shift-KP_Home': 'beginning-of-line-extend'

'Shift-KP_Enter': 'new-line'
'Ctrl-KP_Enter': 'new-line'
'Alt-KP_Enter': 'new-line'

'Ctrl-Right': 'forward-word(gravity="end")'

# Cursor movement and selection

'Alt-B': 'backward-word'
'Alt-F': 'forward-word'
'Alt-less': 'start-of-document'
'Ctrl-X Bracketleft': 'start-of-document'
'Alt-greater': 'end-of-document'
'Ctrl-X Bracketright': 'end-of-document'
'Ctrl-A': 'beginning-of-line'
'Ctrl-E': 'end-of-line'
'Ctrl-N': 'next-line'
'Ctrl-M': 'brace-match'
'Ctrl-P': 'previous-line'
'Ctrl-F': 'forward-char'
'Ctrl-B': 'backward-char'
'Ctrl-V': 'forward-page'
'Alt-V': 'backward-page'
'Ctrl-L': 'center-cursor'
'Alt-G': 'goto-line'
'Alt-L': 'goto-line'
'Alt-{': 'previous-blank-line(threshold=1)'
'Alt-}': 'next-blank-line(threshold=1)'

# Clipboard and related

'Ctrl-Space': 'set-mark-command'
'Ctrl-@': 'set-mark-command'
'Ctrl-G': 'stop-mark-command'
'Ctrl-X Ctrl-X': 'exchange-point-and-mark'
'Ctrl-W': 'cut'
'Ctrl-Y': 'yank-line', 'paste'
'Alt-W': 'copy'
'Ctrl-D': 'forward-delete-char'
'Alt-D': 'forward-delete-word'
'Ctrl-K': 'kill-line'
'Ctrl-H': 'backward-delete-char'
'Ctrl-Slash': 'undo'
'Ctrl-underscore': 'undo'
'Ctrl-X U': 'undo'
'Ctrl-Period': 'redo'

# Search manager

'Ctrl-9': 'search'
'Ctrl-parenleft': 'batch-search'
'Ctrl-0': 'replace'
'Ctrl-parenright': 'batch-replace'
'Alt-Period': 'replace-and-search'
'Ctrl-Alt-F': 'search-sel-forward'
'Ctrl-Alt-B': 'search-sel-backward'

#  Mini-search commands

'Ctrl-S': 'isearch-forward'
'Ctrl-R': 'isearch-backward'
'Ctrl-C M': 'isearch-sel'
'Ctrl-C S': 'isearch-sel-forward'
'Ctrl-C R': 'isearch-sel-backward'
'Ctrl-Alt-S': 'isearch-forward-regex'
'Ctrl-Alt-R': 'isearch-backward-regex'
'Alt-percent': 'query-replace'
'Ctrl-Alt-percent': 'query-replace-regex'
'Alt-percent': 'query-replace'
'Alt-@': 'replace-string'
'Ctrl-Alt-@': 'replace-string-regex'

# File operations

'Ctrl-X Ctrl-S':'save'
'Ctrl-X Ctrl-W':'write-file'
'Ctrl-X Ctrl-C': 'quit'
'Ctrl-X Ctrl-F': 'open-from-keyboard'
'Ctrl-X Ctrl-O': 'open-from-project'
'Ctrl-X I': 'insert-file'
'Ctrl-X K': 'kill-buffer'

# Macros

'Ctrl-X parenleft': 'start-kbd-macro'
'Ctrl-X parenright': 'stop-kbd-macro'
'Ctrl-X E': 'execute-kbd-macro'

# Bookmarks

'Ctrl-X R M': 'set-bookmark'
'Ctrl-X R T': 'toggle-bookmark'
'Ctrl-X R B': 'goto-bookmark'
'Ctrl-X R Return': 'show-bookmarks'

# Indentation and reformatting

'Ctrl-C greater': 'indent-region'
'Ctrl-C less': 'outdent-region'
'Ctrl-C C': 'comment-out-region'
'Ctrl-C U': 'uncomment-out-region'
'Ctrl-C numbersign': 'comment-toggle'
'Ctrl-J': 'fill-paragraph'
'Alt-Q': 'fill-paragraph'

# Window control and traversal

'Ctrl-X 5 2': 'new-document-window'
'Ctrl-X 5 0': 'close-window'
'Ctrl-X 5 3': 'new-document-window'
'Ctrl-O': 'next-window'
'Ctrl-X 5 O': 'next-window'
'Ctrl-X B': 'switch-document'
'Ctrl-X D': 'recent-document'
'Ctrl-X P': 'previous-document'
'Ctrl-X N': 'next-document'
'Ctrl-X O': 'move-editor-focus'
'Ctrl-X 1': 'unsplit'
'Ctrl-X 2': 'split-vertically'
'Ctrl-X 3': 'split-horizontally'

# Syntax highlighting

'Ctrl-X L P': 'use-lexer-python'
'Ctrl-X L N': 'use-lexer-none'
'Ctrl-X L C': 'use-lexer-cpp'
'Ctrl-X L H': 'use-lexer-html'
'Ctrl-X L X': 'use-lexer-Xml'
'Ctrl-X L M': 'use-lexer-makefile'
'Ctrl-X L S': 'use-lexer-sql'

# Key/command repeat

'Ctrl-U': 'initiate-repeat'
'Alt-0': 'initiate-repeat-0'
'Alt-1': 'initiate-repeat-1'
'Alt-2': 'initiate-repeat-2'
'Alt-3': 'initiate-repeat-3'
'Alt-4': 'initiate-repeat-4'
'Alt-5': 'initiate-repeat-5'
'Alt-6': 'initiate-repeat-6'
'Alt-7': 'initiate-repeat-7'
'Alt-8': 'initiate-repeat-8'
'Alt-9': 'initiate-repeat-9'

# Debug commands

'Ctrl-X Space': 'break-set', 'break-clear'
'Ctrl-C Ctrl-C': 'debug-continue'
'Ctrl-C Ctrl-S': 'debug-stop'
'Ctrl-C Ctrl-K': 'debug-kill'
'Ctrl-C Bar': 'evaluate-sel-in-shell'

# Other editing commands

'Alt-Tab': 'show-autocompleter'
'Alt-Slash': 'show-autocompleter'
'Alt-Backslash': 'fold-toggle'
'Alt-X': 'command-by-name'
'Esc X': 'command-by-name'
'Alt-g': 'goto-line'
'Ctrl-X 4 A': 'add-change-log-entry'
'Alt-!': 'execute-process'
'Ctrl-X Ctrl-G': 'find-symbol'
'Ctrl-O': 'open-line'
'Ctrl-X Ctrl-T': 'swap-lines(previous=True)'
'Alt-C': 'title-case'
